/*
  example program to get proximity information from fms.
  to be a full example of the protocol it doesn't re-use any fma/fms
  code or data types.

   indent indent -bli0 -bfda -kr -psl fm_proximity.c
*/

#include <stdio.h>
#ifndef _WIN32
#include <netdb.h>
#endif
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#ifndef _WIN32
#include <unistd.h>
#include <pthread.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#endif

/*from fma/libfma/lf_fms_comm.h*/

#define FMS_SERVICE_PORT 3333
#define FMS_CONN_GENERIC 'g'
#define LF_CLIENT_FMS_QUERY_PROXIMITY 7

typedef struct fms_msg_header {
    uint32_t length_32;
    uint32_t msg_type_32;
} fms_msg_header_t;

/*assume no hostname + unit number will exceed this*/
#define MAX_LINE 256

/*
 * Open a socket connection to a remote listener. ripped off from
 * lf_connect_to_host () in fma/libfma/lf_socket.c
 */

static int
connect_to_host(char *hostname,
		int port)
{
    struct hostent *hp;
    struct sockaddr_in addr;
    int one = 1;
    int s;

    /*translate hostname into an address */
    if (!(hp = gethostbyname(hostname))) {
	printf("Error resolving hostname %s\n", hostname);
	return -1;
    }

    /* build full address */
    memcpy(&addr.sin_addr, hp->h_addr, hp->h_length);
    addr.sin_family = AF_INET;
    addr.sin_port = htons(port);

    /* open a socket for connecting */
    if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	printf("error opening socket\n");
	return -1;
    }

    /* set its options */
    if (setsockopt(s, SOL_SOCKET, SO_KEEPALIVE, &one, sizeof(one)) < 0) {
	printf("error setting KEEPALIVE\n");
	close(s);
	return -1;
    }

    /* connect to the remote host */
    if (connect(s, (struct sockaddr *) &addr, sizeof(struct sockaddr_in)) <
	0) {
	printf("error connecting to socket\n");
	close(s);
	return -1;
    }
    return s;
}

/*
 * lf_read - a wrapper around reads since they can return short.
 */
static int
read_socket(int d,
	    void *buf,
	    int len)
{
    int rc;
    int left;

    /*
     * Keep reading until we get everything the caller asked for, or
     * until 0 or error.  We error out on 0 becuase this is a blocking
     * read and should not return 0
     */
    left = len;
    while (left > 0) {
	rc = recv(d, (char *) buf + len - left, left, 0);
	if (rc == 0 || (rc == -1 && errno != EINTR
#if HAVE_DECL_ERESTART
			&& errno != ERESTART
#endif
			&& errno != EAGAIN)) {
	    return -1;
	}
	left -= rc;
    }

    return len;
}

/*
 * a wrapper around writes since they can return short.
 */
static int
write_socket(int d,
	     void *buf,
	     int len)
{
    int rc;
    int left;

    /*
     * Keep writeing until we send everything the caller asked for, or
     * until 0 or error.  We error out on 0 becuase this is a blocking
     * write and should not return 0
     */
    left = len;
    while (left > 0) {
	rc = send(d, (char *) buf + len - left, left, 0);
	if (rc == 0 || (rc == -1 && errno != EINTR
#if HAVE_DECL_ERESTART
			&& errno != ERESTART
#endif
			&& errno != EAGAIN)) {
	    return -1;
	}
	left -= rc;
    }

    return len;
}

/*
 * read a line from a socket into a null terminated string
 * returns length of string or -1 on error. string
 * does not include the newline.
 */

static int
gets_socket(int fd,
	    char *buffer,
	    int size)
{
    int num_read = 0;
    int c = 0;

    while (num_read < size - 1
	   && (c = read_socket(fd, &buffer[num_read], 1)) == 1
	   && buffer[num_read] != '\n')
	num_read++;
    buffer[num_read] = 0;
    return c == 1 ? num_read : -1;
}

int
main(int argc,
     char *argv[])
{
    int i, j, k, fd;
    char connection_type;
    fms_msg_header_t h;
    char s[MAX_LINE + 1];
    int num_groups, level, num_levels, num_nics;

    if (argc != 2) {
	printf("usage %s <fms-server>\n", argv[0]);
	return -1;
    }

    /*connect to fms client port */
    if ((fd = connect_to_host(argv[1], FMS_SERVICE_PORT)) < 0) {
	printf("connect failed\n");
	return -1;
    }

    /*send connection type */
    connection_type = FMS_CONN_GENERIC;
    write_socket(fd, &connection_type, sizeof(connection_type));

    /*build proximity query. no body, just a header. */
    h.length_32 = 0;
    h.msg_type_32 = htonl(LF_CLIENT_FMS_QUERY_PROXIMITY);

    /*send message */
    if (write_socket(fd, &h, sizeof(h)) != sizeof(h)) {
	printf("error sending message\n");
	return -1;
    }

    /*get number of levels */

    if (gets_socket(fd, s, MAX_LINE) <= 0
	|| sscanf(s, "num_levels %d", &num_levels) != 1) {
	printf("missing num_levels\n");
	return 0;
    }

    printf("num_levels %d\n", num_levels);
    for (i = 0; i < num_levels; i++) {
	/*get level */
	if (gets_socket(fd, s, MAX_LINE) <= 0
	    || sscanf(s, "level %d", &level) != 1) {
	    printf("missing level\n");
	    return 0;
	}
	printf("level %d\n", level);

	/*get number of groups */
	if (gets_socket(fd, s, MAX_LINE) <= 0
	    || sscanf(s, "num_groups %d", &num_groups) != 1) {
	    printf("missing num_groups\n");
	    return 0;
	}

	for (j = 0; j < num_groups; j++) {
	    printf("group %d\n", j);

	    /*get number of nics */
	    if (gets_socket(fd, s, MAX_LINE) <= 0
		|| sscanf(s, "num_nics %d", &num_nics) != 1) {
		printf("missing num_nics\n");
		return 0;
	    }
	    for (k = 0; k < num_nics; k++) {
		if (gets_socket(fd, s, MAX_LINE) <= 0) {
		    printf("missing hostname\n");
		    return 0;
		}
		puts(s);
	    }
	}
    }
    return 0;
}
